IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RC_CLI_CONV_PBM_CONTROLE_AJUSTES]') AND type in (N'U')) 
begin 
CREATE TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_AJUSTES](
	[CD_CTR] [int] IDENTITY(1,1) NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[DT_MOVIMENTO] [datetime] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[HISTORICO] [varchar](450) NOT NULL,
	[QT_MOVIMENTO] [money] NOT NULL,
	[TP_TRANSACAO] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL
 CONSTRAINT [PK_RC_CLI_CONV_PBM_CONTROLE_AJUSTES] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_AJUSTES] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_AJUSTES_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_AJUSTES] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_AJUSTES_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_AJUSTES] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_AJUSTES_TP_TRANSACAO]  DEFAULT ((0)) FOR [TP_TRANSACAO]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_AJUSTES] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_AJUSTES_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_AJUSTES] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_AJUSTES_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_AJUSTES] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_AJUSTES_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_AJUSTES] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_AJUSTES_HISTORICO]  DEFAULT ('') FOR [HISTORICO]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_AJUSTES] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_AJUSTES_QT_MOVIMENTO]  DEFAULT ((0)) FOR [QT_MOVIMENTO]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_AJUSTES]  WITH CHECK ADD  CONSTRAINT [FK_RC_CLI_CONV_PBM_CONTROLE_AJUSTES_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_AJUSTES] CHECK CONSTRAINT [FK_RC_CLI_CONV_PBM_CONTROLE_AJUSTES_EST_PROD]
end